/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.event;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.event.IVWTableActionEventSource;
import filenet.vw.toolkit.utils.event.IVWTableActionListener;
import filenet.vw.toolkit.utils.event.VWTableActionEvent;
import javax.swing.event.EventListenerList;

public class VWTableActionEventNotifier
implements IVWTableActionEventSource {
    private EventListenerList m_tableActionListeners = null;

    public void notifyTableAction(int nEventId) {
        try {
            if (this.m_tableActionListeners != null && this.m_tableActionListeners.getListenerCount() > 0) {
                VWTableActionEvent event = new VWTableActionEvent(this, nEventId);
                Object[] listeners = this.m_tableActionListeners.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != IVWTableActionListener.class) continue;
                    ((IVWTableActionListener)listeners[i + 1]).tableActionPerformed(event);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseReferences() {
        this.m_tableActionListeners = null;
    }

    public void addTableActionListener(IVWTableActionListener listener) {
        if (this.m_tableActionListeners == null) {
            this.m_tableActionListeners = new EventListenerList();
        }
        this.removeTableActionListener(listener);
        this.m_tableActionListeners.add(IVWTableActionListener.class, listener);
    }

    public void removeTableActionListener(IVWTableActionListener listener) {
        if (this.m_tableActionListeners != null) {
            this.m_tableActionListeners.remove(IVWTableActionListener.class, listener);
        }
    }
}

